{
	displayorder [ 
		"scenario-9" "scenario-5" "scenario-1" "scenario-7" "scenario-2" 
		"scenario-3" "scenario-10" "scenario-4" "scenario-8" "scenario-6" 
		"scenario-12" "scenario-11" "scenario-13" "scenario-14"
		]
	scenarios [
	{
		id "scenario-1"
		locname "scenario.1.name"
		locdesc "scenario.1.desc"
		buildingname "scenario.1.bldg"
		rngseed 1006
		tags [ "scenario" "scenario-1" ] ;; but these tags can be arbitrary

		filename "Scenarios/Scenario1"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -76 right 76 top 25 bottom -15 }
	        lot { left -75 right 75 top 18 bottom -10 floorspacecap 3000 }
	        caps { floorspacemax 4500 plazaupgradetiles 5 }
	    }
	    starting {
            startingMoney 15000
            startingEconomy -0.6
	    }

	    quests {
	    	maxactive { value 2 mods [ { #type golden-age-modifier id goldenage-apartments-free multiplier 1.5 } ] }
	    	globalimports [ population-one population-two population-three office-level-one office-level-two office-level-three office-level-four office-peeps-one office-peeps-two office-peeps-three ]
	    	items [
            	{
            		id s1-quest-retail-one
            		locname "s1-quest-retail-one"
            		locdesc	"s1-quest-retail-one.desc"
            		visreqs [
            			{ #type prestige-requirement value 1 }
            		]
            		reqs [
            			{ #type prestige-requirement value 2 }
            		]
            		goals [
            			{
            				id s1-quest-retail-one-g1
            				#type goal-have-peep-count count allvisitors test atleast goal 35
            				locdesc "s1-quest-retail-one-g1"
            			}
            			{
            				id s1-quest-retail-one-g2
            				#type goal-count-units tags [ retail-one-a ] test atleast goal 1
            				locdesc "s1-quest-retail-one-g2"
            			}
            			{
            				id s1-quest-retail-one-g3
            				#type goal-count-units tags [ retail-one-b ] test atleast goal 1
            				locdesc "s1-quest-retail-one-g3"
            			}
            			{
            				id s1-quest-retail-one-g4
            				#type goal-count-units tags [ retail-one-c ] test atleast goal 1
            				locdesc "s1-quest-retail-one-g4"
            			}
            			{
            				id s1-quest-retail-one-g5
            				#type goal-count-units tags [ retail-one-d ] test atleast goal 1
            				locdesc "s1-quest-retail-one-g5"
            			}
            			{
            				id s1-quest-retail-one-g6
            				#type goal-count-units tags [ retail-one-e-flowers ] test atleast goal 1
            				locdesc "s1-quest-retail-one-g6"
            			}
            			{
            				id s1-quest-retail-one-g7
            				#type goal-count-units tags [ retail-one-e-bottle ] test atleast goal 1
            				locdesc "s1-quest-retail-one-g7"
            			}
            		]
            		startcash 500
            		endcash 2500
            		endgrants [
            			{ #type grant-tokens type favors value 10 }
            		]
            	}
            	{
            		id s1-quest-retail-two
            		locname "s1-quest-retail-two"
            		locdesc "s1-quest-retail-two.desc"
            		visreqs [
            			{ #type prestige-requirement value 4 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s1-quest-retail-one" }
            		]
            		goals [
            			{
            				id s1-quest-retail-two-g1
            				#type goal-have-peep-count count allvisitors test atleast goal 50
            				locdesc "s1-quest-retail-two-g1"
            			}
            			{
            				id s1-quest-retail-two-g2
            				#type goal-count-units tags [ retail-two-a ] test atleast goal 1
            				locdesc "s1-quest-retail-two-g2"
            			}
            			{
            				id s1-quest-retail-two-g3
            				#type goal-count-units tags [ retail-two-b ] test atleast goal 1
            				locdesc "s1-quest-retail-two-g3"
            			}
            			{
            				id s1-quest-retail-two-g4
            				#type goal-count-units tags [ retail-two-c-shoes ] test atleast goal 1
            				locdesc "s1-quest-retail-two-g4"
            			}
            			{
            				id s1-quest-retail-two-g5
            				#type goal-count-units tags [ retail-two-c-purses ] test atleast goal 1
            				locdesc "s1-quest-retail-two-g5"
            			}
            			{
            				id s1-quest-retail-two-g6
            				#type goal-count-units tags [ retail-two-d ] test atleast goal 1
            				locdesc "s1-quest-retail-two-g6"
            			}
            		]
            		startcash 500
            		endcash 5000
            		endgrants [
            			{ #type grant-tokens type favors value 50 }
            		]
            	}
            	{
            		id s1-quest-retail-three
            		locname "s1-quest-retail-three"
            		locdesc "s1-quest-retail-three.desc"
            		visreqs [
            			{ #type prestige-requirement value 9 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s1-quest-retail-two" }
            		]
            		goals [
            			{
            				id s1-quest-retail-three-g2
            				#type goal-count-units tags [ departmentstore ] test atleast goal 1
            				locdesc "s1-quest-retail-three-g2"
            			}
            			{
            				id s1-quest-retail-three-g3
            				#type goal-count-units tags [ homegoods-three ] test atleast goal 1
            				locdesc "s1-quest-retail-three-g3"
            			}
            			{
            				id s1-quest-retail-three-g4
            				#type goal-count-units tags [ electronics-three ] test atleast goal 1
            				locdesc "s1-quest-retail-three-g4"
            			}
            			{
            				id s1-quest-retail-three-g5
            				#type goal-count-units tags [ food-three ] test atleast goal 1
            				locdesc "s1-quest-retail-three-g5"
            			}
            		]
            		startcash 500
            		endcash 10000
            		endgrants [
            			{ #type grant-prestige value 2 }
            		]
            	}
		    ]
		}

		medals [
			{	id s1-victory-bronze
				level 0
				locname "s1-victory-bronze"
				locdesc "s1-victory-bronze.desc"
				goals [
					{ id s1-victory-bronze-g1
				      locdesc "s1-victory-bronze-g1"
				      #type goal-have-revenues test atleast goal 20000 }
				    {
				    	id s1-victory-bronze-g2
				    	locdesc "s1-victory-bronze-g2"
				    	#type goal-count-floor-tiles test atleast goal 1500
				    }
				]
			}
			{	id s1-victory-silver
				level 1
				locname "s1-victory-silver"
				locdesc "s1-victory-silver.desc"
				goals [
					{ id s1-victory-silver-g1
				      locdesc "s1-victory-silver-g1"
				      #type goal-have-revenues test atleast goal 40000 }
					{ id s1-victory-silver-g2
					  locdesc "s1-victory-silver-g2"
					  #type goal-have-prestige test atleast goal 20 }
				]
			}
			{	id s1-victory-gold
				level 2
				locname "s1-victory-gold"
				locdesc "s1-victory-gold.desc"
				goals [
					{
				    	id s1-victory-gold-g1
				    	locdesc "s1-victory-gold-g1"
				    	#type goal-count-floor-tiles test atleast goal 2500
				    }
				    { id s1-victory-gold-g2
					  locdesc "s1-victory-gold-g2"
					  #type goal-have-peep-count count alllocals test atleast goal 250 }
				]
			}
		]
	}

	{
		id "scenario-2"
		locname "scenario.2.name"
		locdesc "scenario.2.desc"
		buildingname "scenario.2.bldg"
		rngseed 42
		tags [ "scenario" "scenario-2" ]

		filename "Scenarios/Scenario2"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -36 right 24 top 80 bottom -20 }
	        lot { left -13 right 13 top 40 bottom -10 floorspacecap 1200 }
	        caps { floorspacemax 2200 plazaupgradetiles 2 }
	    }
	    starting {
            startingMoney 7500
            startingEconomy 0.25
	    }
	    reqs [
	    	{ #type medals-achieved-requirement scenarioid "scenario-5" }
	    ]
	    quests {
	    	maxactive { value 2 mods [ { #type golden-age-modifier id goldenage-apartments-free multiplier 1.5 } ] }
	    	globalimports [ restaurant-small restaurant-medium restaurant-large restaurant-gourmet retail-small retail-medium retail-large retail-lux apartments-one apartments-two apartments-three apartments-four office-level-one office-peeps-one office-level-two office-level-three office-level-four office-peeps-two office-peeps-three residential-peeps-one residnetial-peeps-two residential-peeps-three residential-peeps-four residential-luxury-one residential-luxury-two residential-luxury-three ]
	    	items [
	    		{
	    			id s2-quest-one
	    			locname "s2-quest-one"
	    			locdesc	"s2-quest-one.desc"
	    			visreqs [
	    				{ #type prestige-requirement value 2 }
	    			]
	    			goals [
	    				{
	    					id s2-quest-one-g1
	    					#type goal-count-units tags [ decorator ] test atleast goal 1
	    					locdesc "s2-quest-one-g1"
	    				}
	    				{
	    					id s2-quest-one-g2
	    					#type goal-count-units tags [ painting-small ] test atleast goal 1
	    					locdesc "s2-quest-one-g2"
	    				}
	    				{
	    					id s2-quest-one-g3
	    					#type goal-count-units tags [ sculpture-small ] test atleast goal 1
	    					locdesc "s2-quest-one-g3"
	    				}
	    			]
	    			startcash 500
	    			endcash 10000
	    			endgrants [
	    				{ #type grant-tokens type favors value 25 }
	    				{ #type grant-tokens type buzz value 50 }
	    			]
	    		}
	    		{
	    			id s2-quest-two
	    			locname "s2-quest-two"
	    			locdesc	"s2-quest-one.desc"
	    			visreqs [
	    				{ #type consultant-upgrade-requirement id "cons-a-2" }
	    			]
	    			goals [
	    				{
	    					id s2-quest-two-g1
	    					#type goal-count-units tags [ dealer ] test atleast goal 1
	    					locdesc "s2-quest-two-g1"
	    				}
	    				{
	    					id s2-quest-two-g2
	    					#type goal-count-units tags [ painting-medium ] test atleast goal 1
	    					locdesc "s2-quest-two-g2"
	    				}
	    				{
	    					id s2-quest-two-g3
	    					#type goal-count-units tags [ sculpture-medium ] test atleast goal 1
	    					locdesc "s2-quest-two-g3"
	    				}
	    			]
	    			startcash 500
	    			endcash 20000
	    			endgrants [
	    				{ #type grant-tokens type favors value 50 }
	    				{ #type grant-tokens type buzz value 100 }
	    			]
	    		}
	    		{
	    			id s2-quest-three
	    			locname "s2-quest-three"
	    			locdesc "s2-quest-three.desc"
	    			visreqs [
	    				{ #type consultant-upgrade-requirement id "cons-a-3" }
	    			]
	    			reqs [
	    				{ #type quest-complete-requirement id "s2-quest-two" }
	    			]
	    			goals [
	    				{
	    					id s2-quest-three-g1
	    					#type goal-count-units tags [ gallery ] test atleast goal 1
	    					locdesc "s2-quest-three-g1"
	    				}
	    				{
	    					id s2-quest-three-g2
	    					#type goal-count-units tags [ indoor-fountain ] test atleast goal 1
	    					locdesc "s2-quest-three-g2"
	    				}
	    				{
	    					id s2-quest-three-g3
	    					#type goal-count-units tags [ sculpture-large-inside ] test atleast goal 1
	    					locdesc "s2-quest-three-g3"
	    				}
	    			]
	    			startcash 500
	    			endcash 40000
	    			endgrants [
	    				{ #type grant-prestige value 2 }
	    			]
	    		}
	    		{
	    			id s2-quest-offices-one
	    			locname "s2-quest-offices-one"
	    			locdesc "s2-quest-offices-one.desc"
	    			reqs [
	    				{ #type quest-complete-requirement id "office-level-one" }
	    			]
	    			goals [
	    				{
	    					id s2-quest-offices-one-g1
	    					#type goal-count-units tags [ insurance ] test atleast goal 6
	    					locdesc "s2-quest-offices-one-g1"
	    				}
	    				{
	    					id s2-quest-offices-one-g2
	    					#type goal-count-units tags [ accounting ] test atleast goal 6
	    					locdesc "s2-quest-offices-one-g2"
	    				}
	    			]
	    			startcash 1500
	    			endcash 500
	    			endgrants [
	    				{ #type grant-tokens type buzz value 50 }
	    			]
	    		}
	    		{
	    			id s2-quest-apartments-one
	    			locname "s2-quest-apartments-one"
	    			locdesc "s2-quest-apartments-one.desc"
	    			reqs [
	    				{ #type quest-complete-requirement id "apartments-one" }
	    			]
	    			goals [
	    				{
	    					id s2-quest-apartments-one-g1
	    					#type goal-count-units tags [ apt-studio-low apt-studio-high ] test atleast goal 15
	    					locdesc "s2-quest-apartments-one-g1"
	    				}
	    			]
	    			startcash 1500
	    			endcash 500
	    			endgrants [
	    				{ #type grant-tokens type buzz value 50 }
	    			]
	    		}
	    	]
	    }
		medals [
			{
				id s2-victory-bronze
				locname "s2-victory-bronze"
				locdesc "s2-victory-bronze.desc"
				level 0
				goals [
					{
						id s2-victory-bronze-g1
						locdesc "s2-victory-bronze-g1"
						#type goal-count-floor-tiles test atleast goal 800
					}
					{
						id s2-victory-bronze-g2
						locdesc "s2-victory-bronze-g2"
						#type goal-count-floors aboveground #true test atleast goal 30
					}
				]
			}
			{
				id s2-victory-silver
				locname "s2-victory-silver"
				locdesc "s2-victory-silver.desc"
				level 1
				goals [
					{
						id s2-victory-silver-g1
						locdesc "s2-victory-silver-g1"
						#type goal-count-floors aboveground #true test atleast goal 45
					}
					{
						id s2-victory-silver-g2
						locdesc "s2-victory-silver-g2"
						#type goal-have-peep-count count alllocals test atleast goal 200
					}
				]
			}
			{
				id s2-victory-gold
				locname "s2-victory-gold"
				locdesc "s2-victory-gold.desc"
				level 2
				goals [
					{
						id s2-victory-gold-g1
						locdesc "s2-victory-gold-g1"
						#type goal-have-peep-count count alllocals test atleast goal 250
					}
					{
						id s2-victory-gold-g2
						locdesc "s2-victory-gold-g2"
						#type goal-have-prestige test atleast goal 30
					}
				]
			}
		]
	}
	{
		id "scenario-3"
		locname "scenario.3.name"
		locdesc "scenario.3.desc"
		buildingname "scenario.3.bldg"
		rngseed 19131
		tags [ "scenario" "scenario-3" ]

		filename "Scenarios/Scenario3"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -30 right 30 top 60 bottom -12 }
	        lot { left -28 right 28 top 40 bottom -10 floorspacecap 2300 }
	        caps { floorspacemax 3400 plazaupgradetiles 2 }
	    }
	    starting {
            startingMoney 10000
            startingEconomy 0.25
	    }
	    reqs [
	    	{ #type medals-achieved-requirement scenarioid "scenario-1" }
	    ]
	    quests {
	    	maxactive { value 2 mods [ { #type golden-age-modifier id goldenage-apartments-free multiplier 1.5 } ] }
	    	globalimports [ restaurant-small restaurant-medium restaurant-large restaurant-gourmet retail-small retail-medium retail-large retail-lux ]
	    	items [
            	{
            		id s3-quest-one
            		locname "s3-quest-one"
            		locdesc "s3-quest-one.desc"
            		visreqs [
            			{ #type prestige-requirement value 1 }
            		]
            		goals [
            			{
            				id s3-quest-one-g1
            				#type goal-count-units tags [ lobbyist ] test atleast goal 1
            				locdesc "s3-quest-one-g1"
            			}
            			{
            				id s3-quest-one-g2
            				#type goal-count-units tags [ support-construction-expanded ] test atleast goal 1
            				locdesc "s3-quest-one-g2"
            			}
            		]
            		startcash 500
            		endcash 5000
            		endgrants [
            			{ #type grant-tokens type favors value 50 }
            		]
            	}
            	{
            		id s3-quest-two
            		locname "s3-quest-two"
            		locdesc "s3-quest-two.desc"
            		visreqs [
            			{ #type consultant-upgrade-requirement id "cons-c-1" }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s3-quest-one"  }
            		]
            		goals [
            			{
            				id s3-quest-two-g1
            				#type goal-count-units tags [ metro ] test atleast goal 1
            				locdesc "s3-quest-two-g1"
            			}
            			{
            				id s3-quest-two-g2
            				#type goal-have-peep-count count allvisitors test atleast goal 30
            				locdesc "s3-quest-two-g2"
            			}
            		]
            		startcash 500
            		endcash 7500
            		endgrants [
            			{ #type grant-tokens type favors value 200 }
            		]
            	}
            	{
            		id s3-quest-three
            		locname "s3-quest-three"
            		locdesc "s3-quest-three.desc"
            		visreqs [
            			{ #type quest-complete-requirement id "s3-quest-two" }
            		]
            		goals [
            			{
            				id s3-quest-three-g1
            				#type goal-have-prestige test atleast goal 25
            				locdesc "s3-quest-three-g1"
            			}
            		]
            		startcash 500
            		endcash 10000
            		endgrants [
            			{ #type grant-tokens type favors value 200 }
            			{ #type grant-tokens type buzz value 500 }
            		]
            	}
		    ]
		}
		medals [
			{
	    		id s3-victory-bronze
	    		level 0
	    		locname "s3-victory-bronze"
	    		locdesc "s3-victory-bronze.desc"
	    		goals [
	    			{
	    				id s3-victory-bronze-g1
	    				locdesc "s3-victory-bronze-g1"
	    				#type goal-have-peep-count count specificpeeps type officeworker test atleast goal 100
	    			}
	    			{
	    				id s3-victory-bronze-g2
	    				locdesc "s3-victory-silver-g2"
	    				#type goal-count-units tags [ legal ] test atleast goal 25
	    			}
	    		]
	    	}
	    	{
	    		id s3-victory-silver
	    		level 1
	    		locname "s3-victory-silver"
	    		locdesc "s3-victory-silver.desc"
	    		goals [
	    			{
	    				id s3-victory-silver-g1
	    				locdesc "s3-victory-silver-g1"
	    				#type goal-have-revenues test atleast goal 50000
	    			}
	    			{
	    				id s3-victory-silver-g2
	    				locdesc "s3-victory-silver-g2"
	    				#type goal-count-units tags [ legal ] test atleast goal 50
	    			}
	    			{
	    				id s3-victory-silver-g3
	    				locdesc "s3-victory-bronze-g1"
	    				#type goal-have-peep-count count specificpeeps type officeworker test atleast goal 150
	    			}
	    		]
	    	}
	    	{
	    		id s3-victory-gold
	    		level 2
	    		locname "s3-victory-gold"
	    		locdesc "s3-victory-gold.desc"
	    		goals [
	    			{
	    				id s3-victory-gold-g1
	    				locdesc "s3-victory-gold-g1"
	    				#type goal-have-peep-count count specificpeeps type officeworker test atleast goal 250
	    			}
	    			{
	    				id s3-victory-gold-g2
	    				locdesc "s3-victory-gold-g2"
	    				#type goal-have-revenues test atleast goal 100000
	    			}
	    			{
	    				id s3-victory-gold-g3
	    				locdesc "s3-victory-gold-g3"
	    				 #type goal-count-units tags [ government-office ] test atleast goal 5
	    			}
	    		]
	    	}
	    ]
	}
	{
		id "scenario-4"
		locname "scenario.4.name"
		locdesc "scenario.4.desc"
		buildingname "scenario.4.bldg"
		rngseed 56584566
		tags [ "scenario" "scenario-4" ]

		filename "Scenarios/Scenario4"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -30 right 30 top 80 bottom -12 }
	        lot { left -27 right 27 top 40 bottom -10 floorspacecap 2000 }
	        caps { floorspacemax 5000 plazaupgradetiles 2 }
	    }
	    starting {
            startingMoney 20000
            startingEconomy -0.1
	    }
	    reqs [
	    	{ #type medals-achieved-requirement scenarioid "scenario-2" }
	    ]
	    quests {
	    	maxactive { value 2 mods [ { #type golden-age-modifier id goldenage-apartments-free multiplier 1.5 } ] }
	    	globalimports [ money-zero money-one money-two money-three office-peeps-one office-peeps-one office-peeps-two office-peeps-three residential-peeps-one residential-peeps-two residential-peeps-three residential-peeps-four ]
	    	items [
            	{
            		id s4-quest-one
            		locname "s4-quest-one"
            		locdesc "s4-quest-one.desc"
            		visreqs [
            			{ #type prestige-requirement value 2 }
            		]
            		goals [
            			{
            				id s4-quest-one-g1
            				#type goal-count-units tags [ retail-one ] test atleast goal 6
            				locdesc "s4-quest-one-g1"
            			}
            			{
            				id s4-quest-one-g2
            				#type goal-have-peep-count count allvisitors test atleast goal 25
            				locdesc "s4-quest-one-g2"
            			}
            			{
            				id s4-quest-one-g3
            				#type goal-have-tokens token buzz test atleast goal 100
            				locdesc "s4-quest-one-g3"
            			}
            		]
            		startcash 1000
            		endcash 3000
            		endgrants [
            			{ #type grant-tokens type favors value 25 }
            		]
            	}
            	{
            		id s4-quest-two
            		locname "s4-quest-two"
            		locdesc "s4-quest-two.desc"
            		visreqs [
            			{ #type prestige-requirement value 5 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s4-quest-one" }
            		]
            		goals [
            			{
            				id s4-quest-two-g1
            				#type goal-count-units tags [ retail-two-a ] test atleast goal 1
            				locdesc "s4-quest-two-g1"
            			}
            			{
            				id s4-quest-two-g2
            				#type goal-count-units tags [ retail-two-b ] test atleast goal 1
            				locdesc "s4-quest-two-g2"
            			}
            			{
            				id s4-quest-two-g3
            				#type goal-count-units tags [ retail-two-c-shoes ] test atleast goal 1
            				locdesc "s4-quest-two-g3"
            			}
            			{
            				id s4-quest-two-g4
            				#type goal-count-units tags [ retail-two-c-purses ] test atleast goal 1
            				locdesc "s4-quest-two-g4"
            			}
            			{
            				id s4-quest-two-g5
            				#type goal-count-units tags [ retail-two-d ] test atleast goal 1
            				locdesc "s4-quest-two-g5"
            			}
            			{
            				id s4-quest-two-g6
            				#type goal-have-tokens token buzz test atleast goal 750
            				locdesc "s4-quest-two-g6"
            			}
            		]
            		startcash 500
            		endcash 7500
            		endgrants [
            			{ #type grant-tokens type favors value 50 }
            		]
            	}
            	{
            		id s4-quest-three
            		locname "s4-quest-three"
            		locdesc "s4-quest-three.desc"
            		visreqs [
            			{ #type prestige-requirement value 12 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s4-quest-two" }
            		]
            		goals [
            			{
            				id s4-quest-three-g1
            				#type goal-count-units tags [ dinner-four ] test atleast goal 2
            				locdesc "s4-quest-three-g1"
            			}
            			{
            				id s4-quest-three-g2
            				#type goal-count-units tags [ retail-four ] test atleast goal 3
            				locdesc "s4-quest-three-g2"
            			}
            		]
            		startcash 500
            		endcash 10000
            		endgrants [
            			{ #type grant-tokens type favors value 100 }
            		]
            	}
		    ]
		}
		medals [
			{
				id s4-victory-bronze
				level 0
				locname "s4-victory-bronze"
				locdesc "s4-victory-bronze.desc"
				goals [
					{
						id s4-victory-bronze-g1
						locdesc "s4-victory-bronze-g1"
						#type goal-have-prestige test atleast goal 15
					}
				]
			}
			{
				id s4-victory-silver
				level 1
				locname "s4-victory-silver"
				locdesc "s4-victory-silver.desc"
				goals [
					{
						id s4-victory-silver-g1
						locdesc "s4-victory-silver-g1"
						#type goal-count-floors aboveground #true test atleast goal 50
					}
					{
						id s4-victory-silver-g2
						locdesc "s4-victory-silver-g2"
						#type goal-count-floor-tiles test atleast goal 2000
					}
				]
			}
			{
				id s4-victory-gold
				level 2
				locname "s4-victory-gold"
				locdesc "s4-victory-gold.desc"
				goals [
					{
						id s4-victory-gold-g1
						locdesc "s4-victory-gold-g1"
						#type goal-count-units tags [ mural ] test atleast goal 1
					}
					{
						id s4-victory-gold-g2
						locdesc "s4-victory-gold-g2"
						#type goal-count-units tags [ sculpture ] test atleast goal 1
					}
					{
						id s4-victory-gold-g3
						locdesc "s4-victory-gold-g3"
						#type goal-have-prestige test atleast goal 30
					}
				]
			}
	    ]
	}
	{
		id "scenario-5"
		locname "scenario.5.name"
		locdesc "scenario.5.desc"
		buildingname "scenario.5.bldg"
		rngseed 94103
		tags [ "scenario" "scenario-5" ]

		filename "Scenarios/Scenario5"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -31 right 31 top 80 bottom -12 }
	        lot { left -28 right 28 top 50 bottom -10 floorspacecap 2500 }
	        caps { floorspacemax 4000 plazaupgradetiles 2 }
	    }
	    starting {
            startingMoney 5000
            startingEconomy 0.1
	    }
	    quests {
	    	maxactive { value 2 mods [ { #type golden-age-modifier id goldenage-apartments-free multiplier 1.5 } ] }
	    	globalimports [ residential-peeps-one residential-peeps-two residential-peeps-three residential-peeps-four residential-luxury-one residential-luxury-two residential-luxury-three money-zero money-one money-two money-three ]
	    	items [
            	{
            		id s5-quest-one
            		locname "s5-quest-one"
            		locdesc "s5-quest-one.desc"
            		goals [
            			{
            				id s5-quest-one-g1
            				#type goal-count-units tags [ apt-studio-low ] test atleast goal 15
            				locdesc "s5-quest-one-g1"
            			}
            			{
            				id s5-quest-one-g2
            				#type goal-count-units tags [ apt-1br-low ] test atleast goal 10
            				locdesc "s5-quest-one-g2"
            			}
            		]
            		startcash 500
            		endcash 2500
            		endgrants [
            			{ #type grant-prestige value 1 }
            		]
            	}
            	{
            		id s5-quest-two
            		locname "s5-quest-two"
            		locdesc "s5-quest-two.desc"
            		visreqs [
            			{ #type consultant-upgrade-requirement id "cons-b-1" }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s5-quest-one" }
            		]
            		goals [
            			{
            				id s5-quest-two-g1
            				#type goal-count-units tags [ plaza-seating ] test atleast goal 3
            				locdesc "s5-quest-two-g1"
            			}
            			{
            				id s5-quest-two-g2
            				#type goal-count-units tags [ plaza-tree ] test atleast goal 1
            				locdesc "s5-quest-two-g2"
            			}
            		]
            		startcash 500
            		endcash 2500
            		endgrants [
            			{ #type grant-prestige value 2 }
            		]
            	}
            	{
            		id s5-quest-three
            		locname "s5-quest-three"
            		locdesc "s5-quest-three.desc"
            		visreqs [
            			{ #type prestige-requirement value 12 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s5-quest-two" }
            		]
            		goals [
            			{
            				id s5-quest-three-g1
            				#type goal-count-units tags [ french ] test atleast goal 1
            				locdesc "s5-quest-three-g1"
            			}
            			{
            				id s5-quest-three-g2
            				#type goal-count-units tags [ japanese ] test atleast goal 1
            				locdesc "s5-quest-three-g2"
            			}
            			{
            				id s5-quest-three-g3
            				#type goal-count-units tags [ retail-four-d ] test atleast goal 1
            				locdesc "s5-quest-three-g3"
            			}
            			{
            				id s5-quest-three-g4
            				#type goal-count-units tags [ retail-four-f ] test atleast goal 1
            				locdesc "s5-quest-three-g4"
            			}
            		]
            		startcash 500
            		endcash 2500
            		endgrants [
            			{ #type grant-prestige value 3 }
            		]
            	}
		    ]
		}
		medals [
			{
				id s5-victory-bronze
				locname "s5-victory-bronze"
				locdesc "s5-victory-bronze.desc"
				level 0
				goals [
					{
						id s5-victory-bronze-g1
						locdesc "s5-victory-bronze-g1"
						#type goal-have-peep-count count specificpeeps type resident test atleast goal 100
					}
					{
						id s5-victory-bronze-g2
						locdesc "s5-victory-bronze-g2"
						#type goal-count-units tags [ retail ] test atleast goal 8
					}
				]
			}
			{
				id s5-victory-silver
				locname "s5-victory-silver"
				locdesc "s5-victory-silver.desc"
				level 1
				goals [
					{
						id s5-victory-silver-g1
						locdesc "s5-victory-silver-g1"
						#type goal-have-peep-count count specificpeeps type resident test atleast goal 150
					}
					{
						id s5-victory-silver-g2
						locdesc "s5-victory-silver-g2"
						#type goal-count-units tags [ restaurant ] test atleast goal 12
					}
					{
						id s5-victory-silver-g3
						locdesc "s5-victory-silver-g3"
						#type goal-have-peep-count count allvisitors test atleast goal 50
					}
				]
			}
			{
				id s5-victory-gold
				locname "s5-victory-gold"
				locdesc "s5-victory-gold.desc"
				level 2
				goals [
					{
						id s5-victory-gold-g1
						locdesc "s5-victory-gold-g1"
						#type goal-have-peep-count count specificpeeps type resident test atleast goal 250
					}
					{
						id s5-victory-gold-g2
						locdesc "s5-victory-gold-g2"
						#type goal-have-prestige test atleast goal 30
					}
					{
						id s5-victory-gold-g3
						locdesc "s5-victory-gold-g3"
						#type goal-count-units tags [ apt-four-b ] test atleast goal 10
					}
				]
			}
	    ]
	}
	{
		id "scenario-6"
		locname "scenario.6.name"
		locdesc "scenario.6.desc"
		buildingname "scenario.6.bldg"
		rngseed 60625
		tags [ "scenario" "scenario-6" ]

		filename "Scenarios/Scenario6"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -30 right 30 top 40 bottom -5 }
	        lot { left -18 right 18 top 25 bottom -4 floorspacecap 1044 }
	        caps { floorspacemax 1600 plazaupgradetiles 2 }
	    }
	    starting {
            startingMoney 10000
            startingEconomy -0.25
	    }
	    reqs [
	    	{ #type medals-achieved-requirement scenarioid "scenario-10" }
	    ]
	    quests {
	    	maxactive { value 2 mods [ { #type golden-age-modifier id goldenage-apartments-free multiplier 1.5 } ] }
	    	globalimports [ apartments-one apartments-two apartments-three apartments-four restaurant-small restaurant-medium restaurant-large restaurant-gourmet restaruant retail-small retail-medium retail-large residential-luxury-one residential-peeps-one residnetial-peeps-two residential-peeps-three residential-peeps-four residential-luxury-one residential-luxury-two residential-luxury-three ]
	    	items [
            	{
            		id s6-quest-one
            		locname "s6-quest-one"
            		locdesc "s6-quest-one.desc"
            		goals [
            			{
            				id s6-quest-one-g1
            				#type goal-count-floors aboveground #true test atleast goal 15
            				locdesc "s6-quest-one-g1"
            			}
            		]
            		startcash 500
            		endcash 5000
            		endgrants [
            			{ #type grant-prestige value 1 }
            		]
            	}
            	{
            		id s6-quest-two
            		locname "s6-quest-two"
            		locdesc	"s6-quest-two.desc"
            		visreqs [
            			{ #type prestige-requirement value 3 }
            		]
            		goals [
            			{
            				id s6-quest-two-g1
            				#type goal-count-units tags [ metro ] test atleast goal 1
            				locdesc "s6-quest-two-g1"
            			}
            		]
            		startcash 500
            		endcash 7500
            		endgrants [
            			{ #type grant-prestige value 1 }
            		]
            	}
            	{
            		id s6-quest-three
            		locname "s6-quest-three"
            		locdesc "s6-quest-three.desc"
            		visreqs [
            			{ #type prestige-requirement value 6 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s6-quest-two" }
            		]
            		goals [
            			{
            				id s6-quest-three-g1
            				#type goal-have-golden-age goldenageid goldenage-commercial-feature action finished test atleast goal 1
            				locdesc "s6-quest-three-g1"
            			}
            		]
            		startcash 500
            		endcash 10000
            		endgrants [
            			{ #type grant-prestige value 1 }
            		]
            	}
		    ]
		}
		medals [
			{
				id s6-victory-bronze
				locname "s6-victory-bronze"
				locdesc "s6-victory-bronze.desc"
				level 0
				goals [
					{
						id s6-victory-bronze-g1
						locdesc "s6-victory-bronze-g1"
						#type goal-have-revenues test atleast goal 25000
					}
					{
						id s6-victory-bronze-g2
						locdesc "s6-victory-bronze-g2"
						#type goal-have-peep-count count alllocals test atleast goal 150
					}
					{
						id s6-victory-bronze-g3
						locdesc "s6-victory-bronze-g3"
						#type goal-have-prestige test atleast goal 10
					}
				]
			}
			{
				id s6-victory-silver
				locname "s6-victory-silver"
				locdesc "s6-victory-silver.desc"
				level 1
				goals [
					{
						id s6-victory-silver-g1
						locdesc "s6-victory-silver-g1"
						#type goal-have-revenues test atleast goal 50000
					}
					{
						id s6-victory-silver-g2
						locdesc "s6-victory-silver-g2"
						#type goal-have-peep-count count alllocals test atleast goal 200
					}
					{
						id s6-victory-silver-g3
						locdesc "s6-victory-silver-g3"
						#type goal-have-prestige test atleast goal 16
					}
				]
			}
			{
				id s6-victory-gold
				locname "s6-victory-gold"
				locdesc "s6-victory-gold.desc"
				level 2
				goals [
					{
						id s6-victory-gold-g1
						locdesc "s6-victory-gold-g1"
						#type goal-have-revenues test atleast goal 75000
					}
					{
						id s6-victory-gold-g2
						locdesc "s6-victory-gold-g2"
						#type goal-have-peep-count count alllocals test atleast goal 250
					}
					{
						id s6-victory-gold-g3
						locdesc "s6-victory-gold-g3"
						#type goal-have-prestige test atleast goal 25	
					}
				]
			}
	    ]
	}
	{
		id "scenario-7"
		locname "scenario.7.name"
		locdesc "scenario.7.desc"
		buildingname "scenario.7.bldg"
		rngseed 1976
		tags [ "scenario" "scenario-7" ]

		filename "Scenarios/Scenario7"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -34 right 34 top 60 bottom -5 }
	        lot { left -32 right 32 top 40 bottom -10 floorspacecap 1600 }
	        caps { floorspacemax 2500 plazaupgradetiles 2 }
	    }
	    starting {
            startingMoney 10000
            startingEconomy -0.7
	    }
	    reqs [
	    	{ #type medals-achieved-requirement scenarioid "scenario-9" }
	    ]
	    quests {
	    	maxactive { value 2 mods [ { #type golden-age-modifier id goldenage-apartments-free multiplier 1.5 } ] }
	    	globalimports [ money-zero money-one money-two money-three office-level-one office-level-two office-level-three office-level-four apartments-one apartments-two apartments-three  apartments-four ]
	    	items [
            	{
            		id s7-quest-one
            		locname "s7-quest-one"
            		locdesc "s7-quest-one.desc"
            		visreqs [
            			{ #type prestige-requirement value 4 }
            		]
            		goals [
            			{
            				id s7-quest-one-g1
            				#type goal-count-units tags [ retail-two ] test atleast goal 4
            				locdesc "s7-quest-one-g1"
            			}
            			{
            				id s7-quest-one-g2
            				#type goal-count-units tags [ rest-two ] test atleast goal 4
            				locdesc "s7-quest-one-g2"
            			}
            		]
            		startcash 500
            		endcash 4500
            		endgrants [
            			{ #type grant-tokens type favors value 25 }
            			{ #type grant-tokens type buzz value 50 }
            		]
            	}
            	{
            		id s7-quest-two
            		locname "s7-quest-two"
            		locdesc "s7-quest-two.desc"
            		visreqs [
            			{ #type prestige-requirement value 6 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s7-quest-one" }
            		]
            		goals [
            			{
            				id s7-quest-two-g1
            				#type goal-have-golden-age goldenageid goldenage-infrastucture-freefloor action finished test atleast goal 1
            				locdesc "s7-quest-two-g1"
            			}
            		]
            		startcash 500
            		endcash 8000
            		endgrants [
            			{ #type grant-prestige value 1 }
            		]
            	}
            	{
            		id s7-quest-three
            		locname "s7-quest-three"
            		locdesc "s7-quest-three.desc"
            		visreqs [
            			{ #type prestige-requirement value 8 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s7-quest-two" } 
            		]
            		goals [
            			{
            				id s7-quest-three-g1
            				#type goal-count-units tags [ mural ] test atleast goal 1
            				locdesc "s7-quest-three-g1"
            			}
            		]
            		startcash 500
            		endcash 12000
            		endgrants [
            			{ #type grant-tokens type buzz value 500 }
            		]
            	}
		    ]
		}
		medals [
			{
				id s7-victory-bronze
				locname "s7-victory-bronze"
				locdesc "s7-victory-bronze.desc"
				level 0
				goals [
					{
						id s7-victory-bronze-g1
						locdesc "s7-victory-bronze-g1"
						#type goal-have-cash test atleast goal 50000
					}
					{
						id s7-victory-bronze-g2
						locdesc "s7-victory-bronze-g2"
						#type goal-have-peep-count count alllocals test atleast goal 200
					}
				]
			}
			{
				id s7-victory-silver
				locname "s7-victory-silver"
				locdesc "s7-victory-silver.desc"
				level 1
				goals [
					{
						id s7-victory-silver-g1
						locdesc "s7-victory-silver-g1"
						#type goal-have-cash test atleast goal 75000
					}
					{
						id s7-victory-silver-g2
						locdesc "s7-victory-silver-g2"
						#type goal-have-peep-count count alllocals test atleast goal 300
					}
					{
						id s7-victory-silver-g3
						locdesc "s7-victory-silver-g3"
						#type goal-have-prestige test atleast goal 12
					}
				]
			}
			{
				id s7-victory-gold
				locname "s7-victory-gold"
				locdesc "s7-victory-gold.desc"
				level 2
				goals [
					{
						id s7-victory-gold-g1
						locdesc "s7-victory-gold-g1"
						#type goal-have-peep-count count specificpeeps type officeworker test atleast goal 100
					}
					{
						id s7-victory-gold-g2
						locdesc "s7-victory-gold-g2"
						#type goal-have-peep-count count specificpeeps type resident test atleast goal 100
					}
					{
						id s7-victory-gold-g3
						locdesc "s7-victory-gold-g3"
						#type goal-have-prestige test atleast goal 35
					}
				]
			}
	    ]
	}
	{
		id "scenario-8"
		locname "scenario.8.name"
		locdesc "scenario.8.desc"
		buildingname "scenario.8.bldg"
		rngseed 0
		tags [ "scenario" "scenario-8" ]

		filename "Scenarios/Scenario8"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -50 right 50 top 80 bottom -5 }
	        lot { left -48 right 48 top 50 bottom -10 floorspacecap 4000 }
	        caps { floorspacemax 7500 plazaupgradetiles 8 }
	    }
	    starting {
            startingMoney 15000
            startingEconomy 0.7
	    }
	    reqs [
	    	{ #type medals-achieved-requirement scenarioid "scenario-3" }
	    ]
	    quests {
	    	maxactive { value 2 mods [ { #type golden-age-modifier id goldenage-apartments-free multiplier 1.5 } ] }
	    	globalimports [ population-one population-two population-three money-zero money-one money-two money-three ]
	    	items [
            	{
            		id s8-quest-one
            		locname "s8-quest-one"
            		locdesc "s8-quest-one.desc"
            		visreqs [
            			{ #type prestige-requirement value 2 }
            		]
            		reqs [
            			{ #type entity-count-requirement type atleast count 1 template consultant-aesthetics }
            		]
            		goals [
            			{
            				id s8-quest-one-g1
            				#type goal-count-units tags [ painting-small sculpture-small ] test atleast goal 3
            				locdesc "s8-quest-one-g1"
            			}
            		]
            		startcash 500
            		endcash 4500
            		endgrants [
            			{ #type grant-tokens type favors value 20 }
            		]
            	}
            	{
            		id s8-quest-two
            		locname "s8-quest-two"
            		locdesc "s8-quest-two.desc"
            		visreqs [
            			{ #type prestige-requirement value 4 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s8-quest-one" }
            		]
            		goals [
            			{
            				id s8-quest-two-g1
            				#type goal-count-units tags [ plaza ] test atleast goal 8
            				locdesc "s8-quest-two-g1"
            			}
            		]
            		startcash 500
            		endcash 7500
            		endgrants [
            			{ #type grant-tokens type favors value 50 }
            		]
            	}
            	{
            		id s8-quest-three
            		locname "s8-quest-three"
            		locdesc "s8-quest-three.desc"
            		visreqs [
            			{ #type prestige-requirement value 8 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s8-quest-two" }
            		]
            		goals [
            			{
            				id s8-quest-three-g1
            				#type goal-have-cash test atleast goal 50000
            				locdesc "s8-quest-three-g1"
            			}
            			{
            				id s8-quest-three-g2
            				#type goal-have-prestige test atleast goal 20
            				locdesc "s8-quest-three-g2"
            			}
            		]
            		startcash 500
            		endcash 10000
            		endgrants [
            			{ #type grant-prestige value 1 }
            		]
            	}
		    ]
		}
		medals [
			{
				id s8-victory-bronze
				locname "s8-victory-bronze"
				locdesc "s8-victory-bronze.desc"
				level 0
				goals [
					{
						id s8-victory-bronze-g1
						locdesc "s8-victory-bronze-g1"
						#type goal-count-units tags [ office ] test atleast goal 50
					}
					{
						id s8-victory-bronze-g2
						locdesc "s8-victory-bronze-g2"
						#type goal-count-units tags [ restaurant ] test atleast goal 6
					}
					{
						id s8-victory-bronze-g3
						locdesc "s8-victory-bronze-g3"
						#type goal-count-units tags [ retail ] test atleast goal 8
					}
				]
			}
	;;;;;;;;;;;;;;;;;;;;;;;;;;; NB - the silver and gold goals have been swapped out here and in the scneario file.		
			{
				id s8-victory-silver
				locname "s8-victory-gold"
				locdesc "s8-victory-gold.desc"
				level 1
				goals [
					{
						id s8-victory-gold-g1
						locdesc "s8-victory-gold-g1"
						#type goal-count-units tags [ tech-four ] test atleast goal 2
					}
					{
						id s8-victory-gold-g2
						locdesc "s8-victory-gold-g2"
						#type goal-count-units tags [ creative-four ] test atleast goal 2
					}
					{
						id s8-victory-gold-g3
						locdesc "s8-victory-gold-g3"
						#type goal-count-units tags [ government-office ] test atleast goal 2
					}
					{
						id s8-victory-gold-g4
						locdesc "s8-victory-gold-g4"
						#type goal-count-units tags [ finacial-four ] test atleast goal 2
					}
				]
			}
			{
				id s8-victory-gold
				locname "s8-victory-silver"
				locdesc "s8-victory-silver.desc"
				level 2
				goals [
					{
						id s8-victory-silver-g1
						locdesc "s8-victory-silver-g1"
						#type goal-have-peep-count count specificpeeps type officeworker test atleast goal 200
					}
					{
						id s8-victory-silver-g2
						locdesc "s8-victory-silver-g2"
						#type goal-count-units tags [ gourmet ] test atleast goal 4
					}
					{
						id s8-victory-silver-g3
						locdesc "s8-victory-silver-g3"
						#type goal-count-units tags [ boutique ] test atleast goal 4
					}


				]
			}
	    ]
	}
	{
		id "scenario-9"
		locname "scenario.9.name"
		locdesc "scenario.9.desc"
		buildingname "scenario.9.bldg"
		rngseed 0
		tags [ "scenario" "scenario-9" ]

		filename "Scenarios/Scenario9"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -40 right 40 top 50 bottom -5 }
	        lot { left -36 right 36 top 40 bottom -10 floorspacecap 3000 }
	        caps { floorspacemax 4000 plazaupgradetiles 2 }
	    }
	    starting {
            startingMoney 15000
            startingEconomy -0.1
	    }
	    quests {
	    	maxactive { value 2 mods [ { #type golden-age-modifier id goldenage-apartments-free multiplier 1.5 } ] }
	    	globalimports [ office-level-one office-level-two office-level-three apartments-one apartments-two apartments-three apartments-four ]
	    	items [
            	{
            		id s9-quest-one
            		locname "s9-quest-one"
            		locdesc "s9-quest-one.desc"
            		goals [
            			{
            				id s9-quest-one-g1
            				#type goal-have-tokens token buzz test atleast goal 100
            				locdesc "s9-quest-one-g1"
            			}
            			{
            				id s9-quest-one-g2
            				#type goal-have-peep-count count allvisitors test atleast goal 25
            				locdesc "s9-quest-one-g2"
            			}
            		]
            		startcash 500
            		endcash 2500
            		endgrants [
            			{ #type grant-prestige value 1 }
            		]
            	}
            	{
            		id s9-quest-two
            		locname "s9-quest-two"
            		locdesc "s9-quest-two.desc"
            		visreqs [
            			{ #type prestige-requirement value 4 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s9-quest-one" }
            		]
            		goals [
            			{
            				id s9-quest-two-g1
            				#type goal-count-floors aboveground #true test atleast goal 15
            				locdesc "s9-quest-two-g1"
            			}
            			{
            				id s9-quest-two-g2
            				#type goal-count-units tags [ retail-two ] test atleast goal 4
            				locdesc "s9-quest-two-g2"
            			}
            			{
            				id s9-quest-two-g3
            				#type goal-count-units tags [ rest-two ] test atleast goal 4
            				locdesc "s9-quest-two-g3"
            			}
            		]
            		startcash 500
            		endcash 6000
            		endgrants [
            			{ #type grant-prestige value 2 }
            		]
            	}
            	{
            		id s9-quest-three
            		locname "s9-quest-three"
            		locdesc "s9-quest-three.desc"
            		visreqs [
            			{ #type prestige-requirement value 6 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s9-quest-two" }
            		]
            		goals [
            			{
            				id s9-quest-three-g1
            				#type goal-have-consultant-upgrade upgradeid "cons-a-5" test atleast goal 1
            				locdesc "s9-quest-three-g1"
            			}
            			{
            				id s9-quest-three-g2
            				#type goal-count-units tags [ sculpture-large-inside ] test atleast goal 1
            				locdesc "s9-quest-three-g2"
            			}
            		]
            		startcash 500
            		endcash 10000
            		endgrants [
            			{ #type grant-prestige value 5 }
            		]
            	}
		    ]
		}
		medals [
			{
				id s9-victory-bronze
				locname "s9-victory-bronze"
				locdesc	"s9-victory-bronze.desc"
				level 0
				goals [
					{
						id s9-victory-bronze-g1
						locdesc "s9-victory-bronze-g1"
						#type goal-have-revenues test atleast goal 25000
					}
				]
			}
			{
				id s9-victory-silver
				locname "s9-victory-silver"
				locdesc	"s9-victory-silver.desc"
				level 1
				goals [
					{
						id s9-victory-silver-g1
						locdesc "s9-victory-silver-g1"
						#type goal-have-peep-count count alllocals test atleast goal 250
					}
				]
			}
			{
				id s9-victory-gold
				locname "s9-victory-gold"
				locdesc "s9-victory-gold.desc"
				level 2
				goals [
					{
						id s9-victory-gold-g1
						locdesc "s9-victory-gold-g1"
						#type goal-have-prestige test atleast goal 30
					}
					{
						id s9-victory-gold-g2
						locdesc "s9-victory-gold-g2"
						#type goal-count-units tags [ outdoor-fountain indoor-fountain ] test atleast goal 1
					}
				]
			}
	    ]
	}
	{
		id "scenario-10"
		locname "scenario.10.name"
		locdesc "scenario.10.desc"
		buildingname "scenario.10.bldg"
		rngseed 0
		tags [ "scenario" "scenario-10" ]

		filename "Scenarios/Scenario10"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -60 right 60 top 75 bottom -5 }
	        lot { left -56 right 56 top 50 bottom -15 floorspacecap 5000 }
	        caps { floorspacemax 7500 plazaupgradetiles 8 }
	    }
	    starting {
            startingMoney 10000
            startingEconomy 0
	    }
	    reqs [
	    	{ #type medals-achieved-requirement scenarioid "scenario-7" }
	    ]
	    quests {
	    	maxactive { value 3 mods [ { #type golden-age-modifier id goldenage-apartments-free delta 1 } ] }
	    	globalimports [ office-level-one office-level-two office-level-three office-level-four apartments-one apartments-two apartments-three apartments-four money-zero money-two money-three restaurant-small restaurant-medium restaurant-large restaurant-gourmet retail-small retail-medium retail-large retail-lux ]
	    	items [
            	{
            		id "s10-quest-one"
            		locname "s10-quest-one"
            		locdesc "s10-quest-one.desc"
            		visreqs [
            			{ #type prestige-requirement value 2 }
            		]
            		goals [
            			{
            				id "s10-quest-one-g1"
            				#type goal-count-units tags [ courier ] test atleast goal 1
            				locdesc "s10-quest-one-g1"
            			}
            			{
            				id "s10-quest-one-g2"
            				#type goal-count-units tags [ supplies ] test atleast goal 1
            				locdesc "s10-quest-one-g2"
            			}
            			{
            				id "s10-quest-one-g3"
            				#type goal-count-units tags [ water ] test atleast goal 1
            				locdesc "s10-quest-one-g3"
            			}
            			{
            				id "s10-quest-one-g4"
            				#type goal-count-units tags [ copies ] test atleast goal 1
            				locdesc "s10-quest-one-g4"
            			}
            			{
            				id "s10-quest-one-g5"
            				#type goal-count-units tags [ handyman ] test atleast goal 1
            				locdesc "s10-quest-one-g5"
            			}
            			{
            				id "s10-quest-one-g6"
            				#type goal-count-units tags [ laundry ] test atleast goal 1
            				locdesc "s10-quest-one-g6"
            			}
            			{
            				id "s10-quest-one-g7"
            				#type goal-count-units tags [ support-maintenance ] test atleast goal 1
            				locdesc "s10-quest-one-g7"
            			}
            		]
            		startcash 500
            		endcash 5000
            	}
            	{
            		id "s10-quest-two"
            		locname "s10-quest-two"
            		locdesc "s10-quest-two.desc"
            		visreqs [
            			{ #type prestige-requirement value 5 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s10-quest-one" }
            		]
            		goals [
            			{
            				id "s10-quest-two-g1"
            				#type goal-count-units tags [ bigstatue ] test atleast goal 2
            				locdesc "s10-quest-two-g1"
            			}
            			{
            				id "s10-quest-two-g2"
            				#type goal-have-prestige test atleast goal 25
            				locdesc "s10-quest-two-g2"
            			}
            		]
            		startcash 500
            		endcash 10000
            	}
            	{
            		id "s10-quest-three"
            		locname "s10-quest-three"
            		locdesc "s10-quest-three.desc"
            		visreqs [
            			{ #type prestige-requirement value 18 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s10-quest-two" }
            		]
            		goals [
            			{
            				id "s10-quest-three-g1"
            				#type goal-have-prestige test atleast goal 40
            				locdesc "s10-quest-three-g1"
            			}
            			{
            				id "s10-quest-three-g2"
            				#type goal-count-floors aboveground #true test atleast goal 50
            				locdesc "s10-quest-three-g2"
            			}
            		]
            		startcash 500
            		endcash 15000
            	}
		    ]
		}
		medals [
			{
				id "s10-victory-bronze"
				locname "s10-victory-bronze"
				locdesc "s10-victory-bronze.desc"
				level 0
				goals [
					{
						id "s10-victory-bronze-g1"
						locdesc "s10-victory-bronze-g1"
						#type goal-have-peep-count count specificpeeps type officeworker test atleast goal 100
					}
					{
						id "s10-victory-bronze-g2"
						locdesc "s10-victory-bronze-g2"
						#type goal-have-peep-count count specificpeeps type resident test atleast goal 50
					}
				]
			}
			{
				id "s10-victory-silver"
				locname "s10-victory-silver"
				locdesc "s10-victory-silver.desc"
				level 1
				goals [
					{
						id "s10-victory-silver-g1"
						locdesc "s10-victory-silver-g1"
						#type goal-have-peep-count count specificpeeps type officeworker test atleast goal 200
					}
					{
						id "s10-victory-silver-g2"
						locdesc "s10-victory-silver-g2"
						#type goal-have-peep-count count specificpeeps type resident test atleast goal 100
					}
				]
			}
			{
				id "s10-victory-gold"
				locname "s10-victory-gold"
				locdesc "s10-victory-gold.desc"
				level 2
				goals [
					{
						id "s10-victory-gold-g1"
						locdesc "s10-victory-gold-g1"
						#type goal-have-peep-count count specificpeeps type officeworker test atleast goal 300
					}
					{
						id "s10-victory-gold-g2"
						locdesc "s10-victory-gold-g2"
						#type goal-have-peep-count count specificpeeps type resident test atleast goal 175
					}
				]
			}
	    ]
	}
	{
		id "scenario-12"
		locname "scenario.12.name"
		locdesc "scenario.12.desc"
		buildingname "scenario.12.bldg"
		rngseed 0
		tags [ "scenario" "scenario-12" ]

		filename "Scenarios/Scenario12"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -25 right 25 top 110 bottom -20 }
	        lot { left -20 right 20 top 60 bottom -15 floorspacecap 2500 }
	        caps { floorspacemax 4000 plazaupgradetiles 5 }
	    }
	    starting {
            startingMoney 5000
            startingEconomy 0
	    }
	    reqs [
	    ]
	    quests {
	    	maxactive { value 2 mods [ { #type golden-age-modifier id goldenage-apartments-free delta 1 } ] }
	    	globalimports [ office-level-one office-level-two office-level-three office-level-four money-zero money-one money-two money-three population-one population-two population-three ]
	    	items [
            	{
            		id "s12-quest-one"
            		locname "s12-quest-one"
            		locdesc "s12-quest-one.desc"
            		visreqs [
            			{ #type token-requirement type favors value 10 }
            		]
            		goals [
            			{
            				id "s12-quest-one-g1"
            				#type goal-count-units tags [ decorator ] test atleast goal 1
            				locdesc "s12-quest-one-g1"
            			}
            			{
            				id "s12-quest-one-g2"
            				#type goal-count-units tags [ lobbyist ] test atleast goal 1
            				locdesc "s12-quest-one-g2"
            			}
            			{
            				id "s12-quest-one-g3"
            				#type goal-count-units tags [ building-manager ] test atleast goal 1
            				locdesc "s12-quest-one-g3"
            			}
            		]
            		startcash 500
            		endcash 5000
            	}
            	{
            		id "s12-quest-two"
            		locname "s12-quest-two"
            		locdesc "s12-quest-two.desc"
            		visreqs [
            			{ #type entity-count-requirement type atleast count 1 template consultant-aesthetics-dealer }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s12-quest-one" }
            		]
            		goals [
            			{
            				id "s12-quest-two-g1"
            				#type goal-count-units tags [ painting-small sculpture-small ] test atleast goal 6
            				locdesc "s12-quest-two-g1"
            			}
            			{
            				id "s12-quest-two-g2"
            				#type goal-count-units tags [ painting-medium sculpture-medium ] test atleast goal 3
            				locdesc "s12-quest-two-g2"
            			}
            		]
            		startcash 500
            		endcash 10000
            	}
            	{
            		id "s12-quest-three"
            		locname "s12-quest-three"
            		locdesc "s12-quest-three.desc"
            		visreqs [
            			{ #type prestige-requirement value 13 }
            		]
            		reqs [
            			{ #type quest-complete-requirement id "s12-quest-two" }
            		]
            		goals [
            			{
            				id "s12-quest-three-g1"
            				#type goal-count-units tags [ retail-four-a ] test atleast goal 1
            				locdesc "s12-quest-three-g1"
            			}
            			{
            				id "s12-quest-three-g2"
            				#type goal-count-units tags [ retail-four-b ] test atleast goal 1
            				locdesc "s12-quest-three-g2"
            			}
            			{
            				id "s12-quest-three-g3"
            				#type goal-count-units tags [ retail-four-c ] test atleast goal 1
            				locdesc "s12-quest-three-g3"
            			}
            			{
            				id "s12-quest-three-g4"
            				#type goal-count-units tags [ retail-four-d ] test atleast goal 1
            				locdesc "s12-quest-three-g4"
            			}
            			{
            				id "s12-quest-three-g5"
            				#type goal-count-units tags [ retail-four-e ] test atleast goal 1
            				locdesc "s12-quest-three-g5"
            			}
            			{
            				id "s12-quest-three-g6"
            				#type goal-count-units tags [ retail-four-f ] test atleast goal 1
            				locdesc "s12-quest-three-g6"
            			}
            		]
            		startcash 500
            		endcash 15000
            	}
		    ]
		}
		medals [
			{
				id "s12-victory-bronze"
				locname "s12-victory-bronze"
				locdesc "s12-victory-bronze.desc"
				level 0
				goals [
					{
						id "s12-victory-bronze-g1"
						#type goal-count-units tags [ financial-three ] test atleast goal 10
						locdesc "s12-victory-bronze-g1"
					}
					{
						id "s12-victory-bronze-g2"
						#type goal-have-peep-count count specificpeeps type officeworker test atleast goal 150
						locdesc "s12-victory-bronze-g2"
					}
				]
			}
			{
				id "s12-victory-silver"
				locname "s12-victory-silver"
				locdesc "s12-victory-silver.desc"
				level 1
				goals [
					{
						id "s12-victory-silver-g1"
						#type goal-count-units tags [ finacial-four ] test atleast goal 8
						locdesc "s12-victory-silver-g1"
					}
					{
						id "s12-victory-silver-g2"
						#type goal-count-units tags [ gourmet ] test atleast goal 4
						locdesc "s12-victory-silver-g2"
					}
				]
			}
			{
				id "s12-victory-gold"
				locname "s12-victory-gold"
				locdesc "s12-victory-gold.desc"
				level 2
				goals [
					{
						id "s12-victory-gold-g1"
						#type goal-count-units tags [ mural ] test atleast goal 1
						locdesc "s12-victory-gold-g1"
					}
					{
						id "s12-victory-gold-g2"
						#type goal-count-units tags [ statue-outside ] test atleast goal 1
						locdesc "s12-victory-gold-g2"
					}
					{
						id "s12-victory-gold-g3"
						#type goal-have-prestige test atleast goal 40
						locdesc "s12-victory-gold-g3"
					}
				]
			}
	    ]
	}

	{
		id "scenario-11"
		locname "scenario.11.name"
		locdesc "scenario.11.desc"
		buildingname "scenario.11.bldg"
		rngseed 0
		tags [ "scenario" "scenario-11" ]

		filename "Scenarios/Scenario11"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -50 right 50 top 130 bottom -15 }
	        lot { left -40 right 40 top 40 bottom -8 floorspacecap 3500 }
	        caps { floorspacemax 6000 plazaupgradetiles 5 }
	    }
	    starting {
            startingMoney 15000
            startingEconomy 0
	    }
	    reqs [
	    ]
	    quests {
	    	maxactive { value 2 mods [ { #type golden-age-modifier id goldenage-apartments-free delta 1 } ] }
	    	globalimports [ office-peeps-one office-peeps-two office-peeps-three money-one money-two money-three population-one population-two population-three restaurant-small restaurant-medium restaurant-large restaurant-gourmet retail-small retail-medium retail-large retail-lux ]
	    	items [
            	{
            		id "s11-quest-one"
            		locname "s11-quest-one"
            		locdesc "s11-quest-one.desc"
            		visreqs [
            		;	{ #type entity-count-requirement type atleast count 1 template consultant-civics }
            		]
            		goals [
            			{
            				id "s11-quest-one-g1"
            				#type goal-count-units tags [ metro ] test atleast goal 1
            				locdesc "s11-quest-one-g1"
            			}
            		]
            		startcash 0
            		endcash 10000
            		endgrants [
            			{ #type grant-tokens type favors value 10 }
            			{ #type grant-tokens type buzz value 50 }
            		]
            	}
            	{
            		id "s11-quest-two"
            		locname "s11-quest-two"
            		locdesc "s11-quest-two.desc"
            		visreqs [
            		;	{ #type entity-count-requirement type atleast count 1 template consultant-aesthetics-dealer }
            		]
            		reqs [
            		;	{ #type quest-complete-requirement id "s12-quest-one" }
            		]
            		goals [
            			{
            				id "s11-quest-two-g1"
            				#type goal-count-units tags [ legal ] test atleast goal 12
            				locdesc "s11-quest-two-g1"
            			}
            		]
            		startcash 0
            		endcash 10000
            		endgrants [
            			{ #type grant-tokens type favors value 10 }
            			{ #type grant-tokens type buzz value 50 }
            		]
            	}
            	{
            		id "s11-quest-three"
            		locname "s11-quest-three"
            		locdesc "s11-quest-three.desc"
            		visreqs [
            		;	{ #type prestige-requirement value 13 }
            		]
            		reqs [
            		;	{ #type quest-complete-requirement id "s12-quest-two" }
            		]
            		goals [
            			{
            				id "s11-quest-three-g1"
            				#type goal-count-units tags [ plaza ] test atleast goal 12
            				locdesc "s11-quest-three-g1"
            			}
            			{
            				id "s11-quest-three-g2"
            				#type goal-count-units tags [ statue-outside ] test atleast goal 2
            				locdesc "s11-quest-three-g2" 
            			}
            			{
            				id "s11-quest-three-g3"
            				#type goal-count-units tags [ outdoor-fountain ] test atleast goal 2
            				locdesc "s11-quest-three-g3"
            			}
            		]
            		startcash 0
            		endcash 20000
            		endgrants [
            			{ #type grant-tokens type favors value 20 }
            			{ #type grant-tokens type buzz value 100 }
            		]
            	}
		    ]
		}
		medals [
			{
				id "s11-victory-bronze"
				locname "s11-victory-bronze"
				locdesc "s11-victory-bronze.desc"
				level 0
				goals [
					{
						id "s11-victory-bronze-g1"
						#type goal-count-units tags [ creative-four ] test atleast goal 12
						locdesc "s11-victory-bronze-g1"
					}
					{
						id "s11-victory-bronze-g2"
						#type goal-count-units tags [ tech-four ] test atleast goal 5
						locdesc "s11-victory-bronze-g2"
					}
				]
			}
			{
				id "s11-victory-silver"
				locname "s11-victory-silver"
				locdesc "s11-victory-silver.desc"
				level 1
				goals [
					{
						id "s11-victory-silver-g1"
						#type goal-count-units tags [ tech-four ] test atleast goal 9
						locdesc "s11-victory-silver-g1"
					}
					{
						id "s11-victory-silver-g2"
						#type goal-count-units tags [ finacial-four ] test atleast goal 8
						locdesc "s11-victory-silver-g2"
					}
				]
			}
			{
				id "s11-victory-gold"
				locname "s11-victory-gold"
				locdesc "s11-victory-gold.desc"
				level 2
				goals [
					{
						id "s11-victory-gold-g1"
						#type goal-count-floors aboveground #true test atleast goal 80
						locdesc "s11-victory-gold-g1"
					}
					{
						id "s11-victory-gold-g2"
						#type goal-count-units tags [ french ] test atleast goal 1
						locdesc "s11-victory-gold-g2"
					}
					{
						id "s11-victory-gold-g3"
						#type goal-count-units tags [ japanese ] test atleast goal 1
						locdesc "s11-victory-gold-g3"
					}
					{
						id "s11-victory-gold-g4"
						#type goal-have-peep-count count allvisitors test atleast goal 100
						locdesc "s11-victory-gold-g4"
					}
				]
			}
	    ]
	}
	{
		id "scenario-15"
		locname "scenario.15.name"
		locdesc "scenario.15.desc"
		buildingname "scenario.15.bldg"
		rngseed 0
		tags [ "scenario" "scenario-15" ]

		filename "Scenarios/Scenario15"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -40 right 40 top 90 bottom -8 }
	        lot { left -30 right 30 top 15 bottom -5 floorspacecap 2000 }
	        caps { floorspacemax 4000 plazaupgradetiles 5 }
	    }
	    starting {
            startingMoney 25000
            startingEconomy 0
	    }
	    reqs [
	    ]
	    quests {
	    	maxactive { value 3 mods [ { #type golden-age-modifier id goldenage-apartments-free delta 1 } ] }
	    	globalimports [ apartments-one apartments-two apartments-three apartments-four residential-peeps-one residential-peeps-two residential-peeps-three residential-peeps-four retail-small retail-medium retail-large retail-lux ]
	    	items [
	    		{
                    id s15-quest-smalloffices
                    locname "s15-quest-smalloffices"
                    locdesc "s15-quest-smalloffices.desc"
                    starter #true
                    goals [
                        {
                            id "s15-quest-smalloffices-g1"
                            #type goal-count-units tags [ insurance-one financial-one legal-one creative-one design-one accounting-one ] test atmost goal 0
                            locdesc "s15-quest-smalloffices-g1"
                        }
                    ]
                    endcash 10000
            	}
            	{
            		id "s15-quest-mediumoffices"	
            		locname "s15-quest-mediumoffices"
            		locdesc "s15-quest-mediumoffices.desc"
            		starter #true
            		goals [
            			{
            				id "s15-quest-mediumoffices-g1"
            				#type goal-count-units tags [ legal-two medical-two financial-two creative-two tech-two ] test atmost goal 0
            				locdesc "s15-quest-mediumoffices-g1"
            			}
            		]
            		endcash 10000
            		endgrants [
            			{ #type grant-tokens type favors value 20 }
            			{ #type grant-tokens type buzz value 100 }
            		]
            	}
            	{
            		id "s15-quest-one"
            		locname "s15-quest-one"
            		locdesc "s15-quest-one.desc"
            		visreqs [
            		]
            		goals [
            			{
            				id "s15-quest-one-g1"
            				#type goal-count-units tags [ restaurant-1b restaurant-1c restaurant-1e ] test atmost goal 0
            				locdesc "s15-quest-one-g1"
            			}
            			{
            				id "s15-quest-one-g2"
            				#type goal-count-units tags [ rest-two ] test atleast goal 4
            				locdesc "s15-quest-one-g2"
            			}
            		]
            		startcash 0
            		endcash 7500
            	}
            	{
            		id "s15-quest-two"
            		locname "s15-quest-two"
            		locdesc "s15-quest-two.desc"
            		
            		goals [
            			{
            				id "s15-quest-two-g1"
            				#type goal-have-peep-count count allvisitors test atleast goal 75
            				locdesc "s15-quest-two-g1"
            			}            			
            		]
            		startcash 0
            		endcash 7500
            	}
            	{
            		id "s15-quest-three"
            		locname "s15-quest-three"
            		locdesc "s15-quest-three.desc"
            		goals [
            			{
            				id "s15-quest-three-g1"
            				#type goal-count-units tags [ sculpture-small painting-small ] test atleast goal 6
            				locdesc "s15-quest-three-g1"
            			}
            			{
            				id "s15-quest-three-g2"
            				#type goal-count-units tags [ sculpture-medium painting-medium ] test atleast goal 3
            				locdesc "s15-quest-three-g2"
            			}
            			{
            				id "s15-quest-three-g3"
            				#type goal-count-units tags [ indoor-fountain outdoor-fountain ] test atleast goal 3
            				locdesc "s15-quest-three-g3"
            			}
            		]
            		startcash 0
            		endcash 10000
            	}
		    ]
		}
		medals [
			{
				id "s15-victory-bronze"
				locname "s15-victory-bronze"
				locdesc "s15-victory-bronze.desc"
				level 0
				goals [
					{
						id "s15-victory-bronze-g1"
						#type goal-count-units tags [ office ] test atmost goal 0
						locdesc "s15-victory-bronze-g1"
					}
					{
						id "s15-victory-bronze-g2"
						#type goal-count-units tags [ service-o ] test atmost goal 0
						locdesc "s15-victory-bronze-g2"
					}
					{
						id "s15-victory-bronze-g3"
						#type goal-have-prestige test atleast goal 10
						locdesc "s15-victory-bronze-g3"
					}
				]
			}
			{
				id "s15-victory-silver"
				locname "s15-victory-silver"
				locdesc "s15-victory-silver.desc"
				level 1
				goals [
					{
						id "s15-victory-silver-g1"
						#type goal-count-units tags [ apt-studio-lux lux-1br lux-two lux-three apt-four-b ] test atleast goal 50
						locdesc "s15-victory-silver-g1"
					}
					{
						id "s15-victory-silver-g2"
						#type goal-have-revenues test atleast goal 25000
						locdesc "s15-victory-silver-g2"
					}
				]
			}
			{
				id "s15-victory-gold"
				locname "s15-victory-gold"
				locdesc "s15-victory-gold.desc"
				level 2
				goals [
					{
						id "s15-victory-gold-g1"
						#type goal-have-peep-count count specificpeeps type resident test atleast goal 200
						locdesc "s15-victory-gold-g1"
					}
					{
						id "s15-victory-gold-g2"
						#type goal-count-units tags [ apt-four-b apt-four-a ] test atleast goal 12
						locdesc "s15-victory-gold-g2"
					}
				]
			}
	    ]
	}
	{
		id "scenario-13"
		locname "scenario.13.name"
		locdesc "scenario.13.desc"
		buildingname "scenario.13.bldg"
		rngseed 0
		tags [ "scenario" "scenario-13" ]

		filename "Scenarios/Scenario13"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -45 right 45 top 120 bottom -12 }
	        lot { left -35 right 35 top 60 bottom -8 floorspacecap 4000 }
	        caps { floorspacemax 8000 plazaupgradetiles 5 }
	    }
	    starting {
            startingMoney 15000
            startingEconomy 0
	    }
	    reqs [
	    ]
	    quests {
	    	maxactive { value 2 mods [ { #type golden-age-modifier id goldenage-apartments-free delta 1 } ] }
	    	globalimports [ residential-peeps-one residnetial-peeps-two residential-peeps-three residential-peeps-four residential-luxury-one residential-luxury-two residential-luxury-three retail-small retail-medium retail-large retail-lux ]
	    	items [
            	{
            		id "s13-quest-one"
            		locname "s13-quest-one"
            		locdesc "s13-quest-one.desc"
            		visreqs [
            		]
            		goals [
            			{
            				id "s13-quest-one-g1"
            				#type goal-have-peep-count count alllocals test atleast goal 50
            				locdesc "s13-quest-one-g1"
            			}
            		]
            		startcash 0
            		endcash 1500
            		endgrants [
            			{ #type grant-prestige value 4 }
            		]
            	}
            	{
            		id "s13-quest-two"
            		locname "s13-quest-two"
            		locdesc "s13-quest-two.desc"
            		
            		goals [
            			{
            				id "s13-quest-two-g1"
            				#type goal-have-consultant-upgrade upgradeid "cons-b-1" test atleast goal 1
            				locdesc "s13-quest-two-g1"
            			}
            			{
            				id "s13-quest-two-g2"
            				#type goal-have-consultant-upgrade upgradeid "cons-c-2" test atleast goal 1
            				locdesc "s13-quest-two-g2"
            			}            			
            		]
            		startcash 0
            		endcash 1500
            		endgrants [
            			{ #type grant-prestige value 4 }
            		]
            	}
            	{
            		id "s13-quest-three"
            		locname "s13-quest-three"
            		locdesc "s13-quest-three.desc"
            		visreqs [
            			{ #type quest-complete-requirement id "s13-quest-two" }
            		]
            		goals [
            			{
            				id "s13-quest-three-g1"
            				#type goal-count-units tags [ tech-four ] test atleast goal 1
            				locdesc "s13-quest-three-g1"
            			}
            		]
            		startcash 0
            		endcash 1500
            		endgrants [
            			{ #type grant-prestige value 4 }
            		]
            	}
		    ]
		}
		medals [
			{
				id "s13-victory-bronze"
				locname "s13-victory-bronze"
				locdesc "s13-victory-bronze.desc"
				level 0
				goals [
					{
						id "s13-victory-bronze-g1"
						#type goal-have-revenues test atleast goal 10000
						locdesc "s13-victory-bronze-g1"
					}
					{
						id "s13-victory-bronze-g2"
						#type goal-have-peep-count count alllocals test atleast goal 100
						locdesc "s13-victory-bronze-g2"
					}
				]
			}
			{
				id "s13-victory-silver"
				locname "s13-victory-silver"
				locdesc "s13-victory-silver.desc"
				level 1
				goals [
					{
						id "s13-victory-silver-g1"
						#type goal-count-units tags [ penthouse-medium ] test atleast goal 4
						locdesc "s13-victory-silver-g1"
					}
					{
						id "s13-victory-silver-g2"
						#type goal-count-units tags [ beergarden ] test atleast goal 1
						locdesc "s13-victory-silver-g2"
					}
					{
						id "s13-victory-silver-g3"
						#type goal-count-units tags [ penthouse-luxury ] test atleast goal 2
						locdesc "s13-victory-silver-g3"
					}
					{
						id "s13-victory-silver-g4"
						#type goal-count-units tags [ rooftoprest ] test atleast goal 1
						locdesc "s13-victory-silver-g4"
					}
				]
			}
			{
				id "s13-victory-gold"
				locname "s13-victory-gold"
				locdesc "s13-victory-gold.desc"
				level 2
				goals [
					{
						id "s13-victory-gold-g1"
						#type goal-count-floors aboveground #true test atleast goal 50
						locdesc "s13-victory-gold-g1"
					}
					{
						id "s13-victory-gold-g2"
						#type goal-have-peep-count count alllocals test atleast goal 300
						locdesc "s13-victory-gold-g2"
					}
					{
						id "s13-victory-gold-g3"
						#type goal-have-revenues test atleast goal 100000
						locdesc "s13-victory-gold-g3"
					}
				]
			}
	    ]
	}
	{
		id "scenario-14"
		locname "scenario.14.name"
		locdesc "scenario.14.desc"
		buildingname "scenario.14.bldg"
		rngseed 0
		tags [ "scenario" "scenario-14" ]

		filename "Scenarios/Scenario14"
	    board {
	        ;; board dimensions must be equal or larger to lot dimensions
	        board { left -50 right 50 top 130 bottom -15 }
	        lot { left -40 right 40 top 75 bottom -10 floorspacecap 6500 }
	        caps { floorspacemax 10000 plazaupgradetiles 6 }
	    }
	    starting {
            startingMoney 5000
            startingEconomy 0
	    }
	    reqs [
	    ]
	    quests {
	    	maxactive { value 3 mods [ { #type golden-age-modifier id goldenage-apartments-free delta 1 } ] }
	    	globalimports [ apartments-one apartments-two apartments-three apartments-four office-level-one office-level-two office-level-three office-level-four residential-luxury-one residential-luxury-two residential-luxury-three retail-small retail-medium retail-large retail-lux restaurant-small restaurant-medium restaurant-large restaurant-gourmet ]
	    	items [
            	{
            		id "s14-quest-one"
            		locname "s14-quest-one"
            		locdesc "s14-quest-one.desc"
            		visreqs [
            		]
            		goals [
            			{
            				id "s14-quest-one-g1"
            				#type goal-have-peep-count count alllocals test atleast goal 200
            				locdesc "s14-quest-one-g1"
            			}
            		]
            		startcash 0
            		endcash 10000
            		endgrants [
            			{ #type grant-tokens type favors value 30 }
            			{ #type grant-prestige value 2 }
            		]
            	}
            	{
            		id "s14-quest-two"
            		locname "s14-quest-two"
            		locdesc "s14-quest-two.desc"
            		
            		goals [
            			{
            				id "s14-quest-two-g1"
            				#type goal-have-peep-count count allvisitors test atleast goal 100
            				locdesc "s14-quest-two-g1"
            			}            			 			
            		]
            		startcash 0
            		endcash 10000
            		endgrants [
            			{ #type grant-prestige value 2 }
            			{ #type grant-tokens type buzz value 100 }
            		]
            	}
            	{
            		id "s14-quest-three"
            		locname "s14-quest-three"
            		locdesc "s14-quest-three.desc"
            		goals [
            			{
            				id "s14-quest-three-g1"
            				#type goal-have-revenues test atleast goal 75000
            				locdesc "s14-quest-three-g1"
            			}
            		]
            		startcash 0
            		endcash 5000
            		endgrants [
            			{ #type grant-prestige value 6 }
            		]
            	}
		    ]
		}
		medals [
			{
				id "s14-victory-bronze"
				locname "s14-victory-bronze"
				locdesc "s14-victory-bronze.desc"
				level 0
				goals [
					{
						id "s14-victory-bronze-g1"
						#type goal-count-floors aboveground #true test atleast goal 75
						locdesc "s14-victory-bronze-g1"
					}		
				]
			}
			{
				id "s14-victory-silver"
				locname "s14-victory-silver"
				locdesc "s14-victory-silver.desc"
				level 1
				goals [
					{
						id "s14-victory-silver-g1"
						#type goal-count-floors aboveground #true test atleast goal 100
						locdesc "s14-victory-silver-g1"
					}
				]
			}
			{
				id "s14-victory-gold"
				locname "s14-victory-gold"
				locdesc "s14-victory-gold.desc"
				level 2
				goals [
					{
						id "s14-victory-gold-g1"
						#type goal-count-floors aboveground #true test atleast goal 125
						locdesc "s14-victory-gold-g1"
					}
					{
						id "s14-victory-gold-g2"
						#type goal-have-prestige test atleast goal 50
						locdesc "s14-victory-gold-g2"
					}
				]
			}
	    ]
	}

	]
}